
/**
 * Title:        FakeRMI implementation<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Joe Schwartz<p>
 * Company:      Alkindi, LLC<p>
 * @author Joe Schwartz
 * @version 1.0
 */
package Alkindi.RMITest;

import java.rmi.server.*;
import java.rmi.*;

import Alkindi.BusinessServices.IAccountManager;
import Alkindi.BusinessDataTypes.AccountInfo;
import Alkindi.BusinessDataTypes.SystemUser;
import java.util.Vector;

public class AccountManager extends UnicastRemoteObject implements IAccountManager
{

	public AccountManager() throws RemoteException
	{
		super();
	}

	/**
	Transforms the given SystemUser into a full Alkindi member.
	@roseuid 39C13D15036B
	*/
	public boolean createMember(final SystemUser user, AccountInfo acctInfo) throws RemoteException
	{
		return true;
	}

	/**
	Creates a SystemUser. This is done when a New User begins the process of submitting ratings in order to become a full member.
	@roseuid 39C13CEE00BB
	*/
	public SystemUser createUser() throws RemoteException
	{
		return new BogusSystemUser();
	}

	/**
	This retrieves the AccountInfo object for the given SystemUser.
	@roseuid 39C13E9D03C8
	*/
	public AccountInfo getAccountInfo(SystemUser user) throws RemoteException
	{
		AccountInfo ai = new AccountInfo();
		java.util.Calendar cal = java.util.Calendar.getInstance();
  		cal.set(1970, 3, 4);
  		ai.m_birthDate = cal.getTime();
		ai.m_education = 1;
		ai.m_educationOther = "";
		ai.m_email = "dude@alkindi.com";
  		ai.m_hobbies = 0;
    		ai.m_hobbyOther = "";
      		ai.m_homeZipCode = "10013";
        	ai.m_knickname = "dude";
         	ai.m_password = "boo!";
          	ai.m_profession = 1;
           	ai.m_professionOther = "";
            	ai.m_screenName = "theDude";
             	ai.m_sex = 1;
              	ai.m_validationQuestion1 = 1;
               	ai.m_validationQuestion2 = 2;
              	ai.m_validationAnswer1 = "guy";
               	ai.m_validationAnswer2 = "man";

		return ai;
	}

	/**
	This returns a list of alternative validation questions for the user with the specified login. The return value is a vector of Integer objects.
	@roseuid 39C13DF101D4
	*/
	public java.util.Vector getUserQuestions(java.lang.String login) throws RemoteException
	{
		Vector qv = new Vector();
		String q1 = "What is your name?";
	 	String q2 = "What is your other name?";
		qv.add(q1);
	 	qv.add(q2);
		return qv;
	 }

	/**
	This updates the AccountInfo for the given SystemUser with the values provided.
	@roseuid 39C13ED2000F
	*/
	public boolean updateAccountInfo(SystemUser user, AccountInfo acctInfo) throws RemoteException
	{
		return true;
	}

	/**
	Changes the account status of the given SystemUser to the status provided.
	@roseuid 39AC2FC40109
	*/
	public boolean updateAccountStatus(final int status, SystemUser user) throws RemoteException
	{
		return true;
	}

	/**
	Checks that the supplied login and password match
	@roseuid 399D9A13036B
	*/
	public boolean validateUser(final java.lang.String login, final java.lang.String password) throws RemoteException
	{
		return true;
	}

	/**
	Checks that the given login matches the supplied answers to additional validation questions.
	@roseuid 39C13DAD02BF
	*/
	public SystemUser validateUserQuestions(final java.lang.String login, final java.lang.String answer1, final java.lang.String answer2) throws RemoteException
	{
		return new BogusSystemUser();
	}


}